/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class FluidAnalyzerItem
extends EnergizedPowerEnergyItem {
    public static final long ENERGY_CONSUMPTION_PER_USE = ModConfigs.COMMON_FLUID_ANALYZER_ENERGY_CONSUMPTION_PER_USE.getValue();
    public static final long ENERGY_CAPACITY = ModConfigs.COMMON_FLUID_ANALYZER_CAPACITY.getValue();

    public FluidAnalyzerItem(class_1792.class_1793 props) {
        super(props, ENERGY_CAPACITY, ModConfigs.COMMON_FLUID_ANALYZER_TRANSFER_RATE.getValue(), 0L);
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.fluid_analyzer.txt.shift.1").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.fluid_analyzer.txt.shift.2", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_CONSUMPTION_PER_USE)}).method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.shift_details.txt").method_27692(class_124.field_1054));
        }
    }

    private void useItem(class_1799 itemStack, class_1657 player, List<class_2561> lines) {
        if (this.getEnergy(itemStack) >= ENERGY_CONSUMPTION_PER_USE) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) - ENERGY_CONSUMPTION_PER_USE);
        }
        for (class_2561 component : lines) {
            player.method_43496(component);
        }
        player.method_43496((class_2561)class_2561.method_43473());
    }

    private void addOutputTextForFluidStorage(List<class_2561> components, @Nullable Storage<FluidVariant> fluidStorage, boolean blockFaceSpecificInformation) {
        int tankCount;
        if (fluidStorage == null) {
            components.add((class_2561)class_2561.method_43471((String)("txt.energizedpower.fluid_analyzer.no_fluid_block" + (blockFaceSpecificInformation ? "_side" : ""))).method_27692(class_124.field_1061));
            return;
        }
        Iterator fluidStorageIterator = fluidStorage.iterator();
        for (tankCount = 0; fluidStorageIterator.hasNext() && tankCount < 100; ++tankCount) {
            fluidStorageIterator.next();
        }
        components.add((class_2561)class_2561.method_43469((String)("txt.energizedpower.fluid_analyzer.fluid_output.tank_count" + (blockFaceSpecificInformation ? "_side" : "")), (Object[])new Object[]{tankCount}).method_27692(class_124.field_1078));
        int tankNum = 0;
        for (StorageView fluidView : fluidStorage) {
            if (++tankNum > 100) break;
            boolean fluidEmpty = fluidView.isResourceBlank();
            long fluidAmount = fluidEmpty ? 0L : fluidView.getAmount();
            components.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43469((String)"txt.energizedpower.fluid_analyzer.fluid_output.tank_fluid_content", (Object[])new Object[]{tankNum, fluidEmpty ? "" : class_2561.method_43471((String)((FluidVariant)fluidView.getResource()).getFluid().method_15785().method_15759().method_26204().method_9539()).method_27693(" "), FluidUtils.getFluidAmountWithPrefix(FluidUtils.convertDropletsToMilliBuckets(fluidAmount)), FluidUtils.getFluidAmountWithPrefix(FluidUtils.convertDropletsToMilliBuckets(fluidView.getCapacity()))})).method_27692(class_124.field_1078));
        }
    }

    public class_1269 method_7884(class_1838 useOnContext) {
        class_1937 level = useOnContext.method_8045();
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_1799 stack = useOnContext.method_8041();
        if (this.getEnergy(stack) < ENERGY_CONSUMPTION_PER_USE) {
            this.useItem(stack, useOnContext.method_8036(), List.of(class_2561.method_43469((String)"txt.energizedpower.fluid_analyzer.no_energy_left", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_CONSUMPTION_PER_USE)}).method_27692(class_124.field_1061)));
            return class_1269.field_5812;
        }
        class_2338 blockPos = useOnContext.method_8037();
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        components.add((class_2561)level.method_8320(blockPos).method_26204().method_9518().method_27695(new class_124[]{class_124.field_1073, class_124.field_1075}));
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity == null) {
            components.add((class_2561)class_2561.method_43471((String)"txt.energizedpower.fluid_analyzer.no_fluid_block").method_27692(class_124.field_1061));
            this.useItem(stack, useOnContext.method_8036(), components);
            return class_1269.field_5812;
        }
        this.addOutputTextForFluidStorage(components, (Storage<FluidVariant>)((Storage)FluidStorage.SIDED.find(level, blockPos, null)), false);
        components.add((class_2561)class_2561.method_43471((String)"txt.energizedpower.fluid_analyzer.output_side_information").method_27692(class_124.field_1065));
        this.addOutputTextForFluidStorage(components, (Storage<FluidVariant>)((Storage)FluidStorage.SIDED.find(level, blockPos, (Object)useOnContext.method_8038())), true);
        this.useItem(stack, useOnContext.method_8036(), components);
        return class_1269.field_5812;
    }
}

